#!BPY
""" 
Name: '4DS LS3D Mafia (*.4ds)...'
Blender: 249'
Group: 'Import'
Tooltip: 'Import from 4DS file (*.4ds)'
"""
# ===== GPL LICENSE BLOCK =====
#
# Script copyright (C) Serj Outkin
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ===============================
# Russia, 2009
# ===============================
# TODO: materials\assign primary texture to faces\halo material for lensf\dummy like mesh\interface\morph
# troubles: blender mesh ca't have more 16 materials, scaling not correctly sometime
# last edit: 10 jul 2009

__author__= 'Serj Outkin aka zibob32'
__url__= ('blender.org', 'mafiapub.com')
__version__= '0.0.3'

# file signature
SIGNATURE= 5456948 #text '4DS\000'
# ======================================================================
# const for materials bitflags 
MtlBitflags= {
'MAIN'               : 0x00000001, # MATERIAL_HAS_COLOR in zmodeler 
'PRIM_BMP'           : 0x00040000,
'ENV_BMP'            : 0x00080000,
'ALPHA_BMP'          : 0x40000000,
'ENV_ADD'            : 0x00000100,
'ENV_SIGNED'         : 0x00000200,
'ENV_ADDSMOOTH'      : 0x00001000,
'SMOOTHING'          : 0x00800000, # MATERIAL_TEX_SMOOTHING_STA in zmodeler, for all textures in material ?? i can't see differences
'ANIM'               : 0x04000000,
'2SIDE'              : 0x10000000,
'ADD_EFFECT'         : 0x00008000,
# next parameters will not work without ADD_EFFECT bit
'COLORKEY'           : 0x20000000, # color RGB, where B=0 will be transparent
'ADDITIVE_BLEND'     : 0x80000000, # parameter name from zmodeler
'ADDITIVE_BLEND2'    : 0x02000000, # ??? using for alpha texture ???
}
# ======================================================================
# objects types
OBJ_VISUAL= 0x01
OBJ_DUMMY= 0x06
OBJ_SECTOR= 0x05
# visual objects subtype
OBJ_DEFAULT= 0x00
OBJ_MIRROR= 0x08
OBJ_BBRD= 0x04
OBJ_LENSF= 0x06

import Blender
from Blender import Mathutils, Scene, Mesh, Object, Material, Image, Texture, Lamp, Window, sys as bsys, Draw
import bpy
import bpy.data as bdata
Vect = Mathutils.Vector
Quat = Mathutils.Quaternion
Matrix = Mathutils.Matrix
SCENE = bdata.scenes.active
SCENE_OBJECTS = SCENE.objects
FaceModes= Mesh.FaceModes

try:
    import sys
    import gc
    from struct import unpack
except:
    Draw.PupMenu('Error %t|Need "sys", "struct" python module')
    raise 'fail'
    

try:
    from functools import reduce
except:
    pass    
if not reduce:
    Draw.PupMenu('Error %t|Need "functools" python module') 
    raise 'fail'   

#=======================================================================
SMOOTH= True                                                           # CHANGE ME IF SOME
POSITION = Matrix()
#=======================================================================

if sys.version_info[0] < 3:
    range= xrange
 
# statistics 
VERTEX_COUNT = 0
FACE_COUNT = 0    

# ======================================================================
# 
LOG = ''
MAPSDIR= ['d:\\mafia\\maps\\'] # additional paths for search *.bmp files
sep= bsys.sep
DEFAULT_BMP= Image.Load(sys.path[0] + sep + 'default.bmp')
DEFAULT_BMP.name= 'DEFAULT'
CURRENT_MATERIALS= [] # used for assign materials to mesh

       
# ======================================================================

########################################################################      
def goodFace(idxs): # faces which contain the same vertex multiple times are ignored
    return idxs[0] != idxs[1] and idxs[0] != idxs[2] and idxs[1] != idxs[2]
########################################################################

class Mtl4ds:
    __slots__= '_bf',\
               'idx',\
               'ambCol',\
               'difCol',\
               'emsCol',\
               'alpha'   
    def getBf(self, bfName):
        bf= MtlBitflags[bfName]
        return (self._bf & bf) > 0
    def setBf(self, bfName, val):
        bf= MtlBitflags[bfName]
        if val:
            self._bf= self._bf | bf
        else:
            self._bf= self._bf & (~bf)
            
class MtlList4ds:
    def __init__(self, filename=''):
        path= bsys.dirname(filename) + sep
        self.__mapsdir= [\
        path, bsys.cleanpath(path + '..' + sep + 'maps' + sep),\
        path + 'maps' + sep]
    
    def loadImg(self, shortFileName): 
        global LOG
        shortFileName.upper()
        try:
            return Image.Get(shortFileName)
        except:
            pass
        fullpath= None
        for dir in self.__mapsdir + MAPSDIR:
            imagefile= dir + shortFileName 
            if bsys.exists(imagefile):
                try:
                    img= Image.Load(imagefile)
                    img.name= shortFileName
                    #img.setXRep(16)
                    #img.setYRep(16)
                    return img
                except:
                    LOG= LOG + 'can\'t load ' + imagefile + '\n'
                    return DEFAULT_BMP
        LOG= LOG + 'can\'t find ' + shortFileName + '\n'
        return DEFAULT_BMP 
                       
    def load(self, f):
        global LOG
        f.seek(14,0)
        self.list= []
        cnt= unpack('<H', f.read(2))[0] 
        for i in range(cnt):
            m4ds= Mtl4ds()
            buf= unpack('<I fff fff fff f', f.read(44))
            m4ds._bf= buf[0]
            m4ds.ambCol= buf[1:4]
            m4ds.difCol= buf[4:7]
            m4ds.emsCol= buf[7:10]
            m4ds.alpha= buf[10]
            if m4ds.getBf('ENV_BMP'):
                m4ds.envInt= unpack('<f', f.read(4))[0] # env intensity
                m4ds.envBmp= f.read( unpack('B', f.read(1))[0] )
            if m4ds.getBf('PRIM_BMP'):
                m4ds.primBmp= f.read( unpack('B', f.read(1))[0] )
            else:
                f.seek(1,1)
            if m4ds.getBf('ALPHA_BMP'):
                m4ds.alphaBmp= f.read( unpack('B', f.read(1))[0] )
            if m4ds.getBf('ANIM'):
                m4ds._animPars= unpack('<BBIIII',f.read(18))
            m4ds.idx= i
            self.list.append(m4ds)
            
    def toBlender(self):
        global LOG, CURRENT_MATERIALS
        CURRENT_MATERIALS= [] #list of blender materials
        m= Material.New('DUMMY MATERIAL') 
        m.alpha= 0.0
        CURRENT_MATERIALS.append( m )
        for m4ds in self.list:
            m= Material.New()
            m.setSpecCol(m4ds.emsCol) 
            m.setRGBCol(m4ds.difCol)  
            m.setMirCol(m4ds.ambCol)  
            m.alpha= m4ds.alpha
            if m4ds.getBf('ENV_BMP'):
                t= Blender.Texture.New()
                t.setType('Image')
                t.image= self.loadImg(m4ds.envBmp)
                m.setTexture(0,t)
                tm= m.textures[0] # MTex object
                tm.mapto= Texture.MapTo.REF
                tm.texco= Texture.TexCo.REFL 
                tm.blendmode= Texture.BlendModes.MIX
                tm.dvar= m4ds.envInt # ENV MAP intensity, float [0.0,1.0]
            if m4ds.getBf('PRIM_BMP'):
                m.setName( str(m4ds.idx) + ' ' + m4ds.primBmp )
                t= Texture.New('Diffuse')
                t.setType('Image')
                t.image= self.loadImg(m4ds.primBmp)
                m.setTexture(1,t)
                tm= m.textures[1] #MTex
                tm.mapto= Texture.MapTo.COL
                tm.texco= Texture.TexCo.UV
                tm.blendmode= Texture.BlendModes.MIX
            else:
                m.setName( str(m4ds.idx) + ' Null' ) 
            if m4ds.getBf('ALPHA_BMP'):
                t= Texture.New('Alpha')
                t.setType('Image')
                t.image= self.loadImg(m4ds.alphaBmp)
                t.calcAlpha= 1
                m.setMode('ZTransp')
                m.setTexture(2,t)
                tm= m.textures[2] #MTex
                tm.mapto= Texture.MapTo.ALPHA
                tm.texco= Texture.TexCo.UV
                tm.blendmode= Texture.BlendModes.MULTIPLY
            CURRENT_MATERIALS.append(m)
        print '4DS materials was loaded\n',LOG
        #return CURRENT_MATERIALS
            
    def fromBlender(self):
        pass
        
    
class vert4ds:
    __slots__= 'co', 'no', 'uv'
    
class face4ds:
    __slots__= 'vIdxs'
    
class faceGr4ds: # face group
    __slots__='fs', 'mtl'
    
class lod4ds: # lod object
    __slots__= 'viewDist', 'vs', 'fgs' # face groups

class genData4ds:
    __slots__= 'parent', 'co', 'sc', 'ro', 'mark'

class glow4ds:
    __slots__= 'centerDist', 'mtl'
    
class lwin4ds:
    __slots__= 'someData', 'ro', 'float', 'verts'
   
class objProto4ds(object): # prototype for all objects
    def __init__(self):
        self.gd= genData4ds()
        self.name= ''
        self.subname= ''      
          
    def load(self, f):
        buf= unpack('<H fff fff ffff B', f.read(43))
        self.gd = genData4ds()
        self.gd.parent= buf[0]
        self.gd.co= buf[1:4]
        self.gd.sc= buf[4:7]
        self.gd.ro= buf[7:11]
        self.gd.mark= buf[11]
        sLen= unpack('B', f.read(1))[0]
        if sLen:
            self.name= f.read(sLen)
        sLen= unpack('B', f.read(1))[0]
        if sLen:
            self.subname= f.read(sLen)
######## DEBUG ME! SCALING            
    def setBleTransf(self): # sets the object's transformation.. must be applying after hierarchy was set
        co= self.gd.co
        sc= self.gd.sc
        ro= self.gd.ro
        matrix= Matrix([sc[0],0,0,0],
                       [0,sc[2],0,0],
                       [0,0,sc[1],0],
                       [co[0],co[2],co[1],1])       
        rotMatrix= Quat(ro[0],ro[1],ro[3],ro[2]).toMatrix().resize4x4()      
        if self.gd.parent:
            self.inBlender.setMatrix(rotMatrix*matrix)
        else:
            self.inBlender.setMatrix(rotMatrix*matrix*POSITION)
    def setBleLayer(self):
        self.inBlender.Layer= 1<<1
    
class objVisProto4ds(objProto4ds):  # prototype for visual objects  
    def __init__(self):
        self.bf= 0x0000 # bitflags
        objProto4ds.__init__(self)     
    def load(self, f):
        
        self.bf= unpack('<H', f.read(2))
        objProto4ds.load(self, f)
        
    def setBleLayer(self):
        self.inBlender.Layer= 1           
        
        
class objMesh4ds(objVisProto4ds):
    '''Default geometric object in 4ds file'''
    def __init__(self):
        objVisProto4ds.__init__(self)
        self.copyOf= 0
        self.lods= []
        self.type= 'MESH'
        
    def load(self, f):
        objVisProto4ds.load(self, f)
        self.lods= []
        self.copyOf= unpack('<H', f.read(2))[0]
        if self.copyOf: return
        lodCnt= unpack('B', f.read(1))[0]
        for lodIter in range(lodCnt):
            buf= unpack('<f H', f.read(6))
            l= lod4ds()
            l.vs= []                                                                                                   
            l.viewDist= buf[0]
            vCnt= buf[1]
            for i in range(vCnt):
                buf= unpack('<fff fff ff', f.read(32))
                v= vert4ds()
                v.co= buf[0:3]
                v.no= buf[3:6]
                v.uv= buf[6:]
                l.vs.append(v) # add vertex   
            fgCnt= unpack('B', f.read(1))[0]
            l.fgs= []
            for i in range(fgCnt):
                fg= faceGr4ds()
                fg.fs= []
                fCnt= unpack('<H', f.read(2))[0]
                for i in range(fCnt):
                    face= face4ds()
                    face.vIdxs= unpack('<HHH', f.read(6))
                    if goodFace(face.vIdxs): fg.fs.append(face) # add face to faceGroup.faces list
                fg.mtl= unpack('<H', f.read(2))[0]
                l.fgs.append(fg) # add faceGroup to LOD.faceGroups list
            self.lods.append(l) # add LOD to lods list
            
    def toBlender(self):
        global VERTEX_COUNT, FACE_COUNT, CURRENT_MATERIALS
        if self.copyOf:
            self.inBlender= SCENE_OBJECTS.new('Empty','Copy of '+str(self.copyOf))
            return            
        try:
            lod= self.lods[0]
        except:
            self.inBlender= SCENE_OBJECTS.new('Empty','Null mesh: '+self.name)
            return # hmm.. but itpossible 
        vs4= lod.vs  # v - vertex; vs - verteces sequence
        newMesh= bdata.meshes.new(self.name)
        newMesh.mode= Mesh.Modes.NOVNORMALSFLIP 
        # =========== add verts 
        newVerts= newMesh.verts               
        newVerts.extend( [(v4.co[0],v4.co[2],v4.co[1]) for v4 in vs4] )
        newMesh.vertexUV= True
        vertIter= iter(newVerts)
        for v4 in vs4:
            vertIter.next().no= Vect(v4.no[0],v4.no[2],v4.no[1]) # set normal to vector
        VERTEX_COUNT += len(newVerts)  
        # =========== add faces
        newFaces= newMesh.faces  # mesh faces sequence
        allFaces4ds= reduce(lambda x,y: x+y, [fg.fs for fg in lod.fgs])
        newFaces.extend([(f.vIdxs[0],f.vIdxs[2],f.vIdxs[1]) for f in allFaces4ds], ignoreDups=True,  smooth=SMOOTH)
        # =========== add uv to faces
        newMesh.addUVLayer('4ds UV')
        newMesh.activeUVLayer= '4ds UV'
        newMesh.faceUV= True
        newUvs= [Vect(v4.uv[0],-v4.uv[1]+1) for v4 in vs4] # other coord system
        for face in newFaces:
            face.uv= (newUvs[face.v[0].index],newUvs[face.v[1].index],newUvs[face.v[2].index])
        # =========== assign material and uv
        newMesh.materials= [CURRENT_MATERIALS[fg.mtl] for fg in lod.fgs][0:15] # CURRENT_MATERIALS - all 4ds materials in blender
        currMtlIdx= 0
        faceIter= iter(newFaces)                                                
        for fg4 in lod.fgs:              
            try:     currImg= newMesh.materials[currMtlIdx].textures[1].tex.getImage(); #currImg.glLoad()
            except:  currImg= None
            for f4 in fg4.fs:
                face= faceIter.next()
                face.mat= currMtlIdx
                if currImg: 
                    face.image= currImg
                    face.mode= FaceModes.TILES | FaceModes.TEX # | FaceModes.LIGHT
            currMtlIdx += 1
            if currMtlIdx==16: break # very very bad
        FACE_COUNT += len(newFaces)  
        self.inBlender= SCENE_OBJECTS.new(newMesh)
        self.inBlender.addProperty('FaceGroupCnt',len(self.lods[0].fgs),'INT') 
       
class objDummy4ds(objProto4ds):
    def __init__(self):
        objProto4ds.__init__(self)
        self.v1= (-0.5, -0.5, -0.5)
        self.v2= (0.5, 0.5, 0.5)
        self.type= 'DUMMY'
        
    def load(self, f):
        objProto4ds.load(self, f)
        buf= unpack('<fff fff',f.read(24))
        self.v1= buf[0:3]
        self.v2= buf[3:]
        
    def toBlender(self):
        self.inBlender= SCENE_OBJECTS.new('Empty',self.name)

        
class objLensf4ds(objVisProto4ds):
    def __init__(self):
        objVisProto4ds.__init__(self)
        self.blocks= []
        self.type= 'LENSF'
        
    def load(self, f):
        objVisProto4ds.load(self, f)
        self.blocks= []
        bCnt= unpack('B', f.read(1))[0]
        for i in range(bCnt):
            buf= unpack('<fH', f.read(6))
            b= glow4ds()
            b.centerDist= buf[0]
            b.mtl= buf[1]
            self.blocks.append(b)
            
    def toBlender(self):
        self.inBlender= SCENE_OBJECTS.new('Empty',self.name)
        
class objMirror4ds(objVisProto4ds):
    def __init__(self):
        objVisProto4ds.__init__(self)
        self.floats= []
        self.verts= []
        self.faces= []
        self.type= 'MIRROR'
        
    def load(self, f):
        objVisProto4ds.load(self, f)
        self.floats= unpack('30f', f.read(120))
        buf= unpack('<II', f.read(8))
        floatCnt= buf[0]*3
        wordCnt= buf[1]*3
        vs= unpack( str(floatCnt)+'f', f.read(floatCnt*4))
        fs= unpack( '<'+str(wordCnt)+'H', f.read(wordCnt*2))
        self.verts= zip(vs[0::3],vs[2::3],vs[1::3])
        self.faces= zip(fs[0::3],fs[2::3],fs[1::3])
        
    def toBlender(self):
        newMesh= bdata.meshes.new(self.name)
        newVerts= newMesh.verts
        newVerts.extend(self.verts)
        newFaces= newMesh.faces
        newFaces.extend(self.faces)
        self.inBlender= SCENE_OBJECTS.new(newMesh)
        
class objBbrd4ds(objMesh4ds):
    def __init__(self):
        objMesh4ds.__init__(self)
        self.someData= []
        self.type= 'BBRD'
        
    def load(self, f):
        objMesh4ds.load(self, f)
        someData= unpack('<IB', f.read(5)) # maybe not <IB
        
class objSector(objProto4ds):
    def __init__(self):
        objProto4ds.__init__(self)
        self.someData= []
        self.verts= []
        self.faces= []
        self.maxmin= []
        self.lwins= []
        self.type= 'SECTOR'
        
    def load(self, f):
        objProto4ds.load(self, f)
        buf= unpack('<4I', f.read(16))
        self.someData= buf[0:2]
        floatCnt= buf[2]*3
        wordCnt= buf[3]*3
        buf= unpack( str(floatCnt)+'f', f.read(floatCnt*4))
        self.verts= zip(buf[0::3],buf[2::3],buf[1::3])
        buf= unpack( '<'+str(wordCnt)+'H', f.read(wordCnt*2))
        self.faces= zip(buf[0::3],buf[2::3],buf[1::3])
        buf= unpack( '6f', f.read(24))
        self.maxmin= zip(buf[0::3],buf[2::3],buf[1::3])
        self.lwins= []
        winCnt= unpack('B', f.read(1))[0]
        for i in range(winCnt):
            buf= unpack('<B II ffff f', f.read(29))
            w= lwin4ds()
            floatCnt= buf[0]*3
            w.someData= buf[1:3]
            w.ro= buf[3:7]
            w.float= buf[7]
            buf= unpack(str(floatCnt)+'f',f.read(floatCnt*4))
            w.verts= zip(buf[0::3],buf[2::3],buf[1::3])
            self.lwins.append(w)
            
    def toBlender(self):
        newMesh= bdata.meshes.new(self.name)
        newVerts= newMesh.verts
        newVerts.extend(self.verts)
        newFaces= newMesh.faces
        newFaces.extend(self.faces)
        o= SCENE_OBJECTS.new(newMesh)
        self.inBlender= o
        o.setDrawType(2) # wire
        o.restrictRender= True
            
class file4ds:
    def __init__(self):
        self.objList= []
        self.mtlList= []
        self.mapsdir= []
        
    def load(self, filename): #filename 
        f= open(filename ,'rb')
        if SIGNATURE != unpack('<I',f.read(4))[0]:
            raise 'Error: 4DS File not valid: '+fn
        structType= unpack('<H', f.read(2))[0]
        self.mtlList= MtlList4ds(filename)
        self.mtlList.load(f)
        self.objList = []
        oCnt= unpack('<H', f.read(2))[0] 
        for oIt in range(oCnt):
            oType= unpack('B', f.read(1))[0] 
            if   OBJ_VISUAL == oType:
                 oSybType= unpack('B', f.read(1))[0]
                 if   OBJ_DEFAULT == oSybType: o= objMesh4ds()
                 elif OBJ_LENSF == oSybType: o= objLensf4ds()
                 elif OBJ_MIRROR == oSybType: o= objMirror4ds()
                 elif OBJ_BBRD == oSybType: o=objBbrd4ds()
                 else: raise 'Error: Unknown visual object subtype: %i; offset %i; file: %s ' % (oSybType, f.tell(), filename)
            elif OBJ_DUMMY  == oType: o= objDummy4ds()
            elif OBJ_SECTOR == oType: o= objSector()       
            else: raise 'Error: Unknown object type: %i; offset %i; file: %s ' % (oType, f.tell(), filename)
            o.load(f)
            self.objList.append(o)
        f.close()
        del f
        
    def toBlender(self):
        global VERTEX_COUNT, FACE_COUNT, FILENAME
        result= []
        self.mtlList.toBlender() # blender materials accumulate in CURRENT_MATERIALS
        for obj4ds in self.objList:
            obj4ds.toBlender()
            parent= obj4ds.gd.parent
            if parent:
                self.objList[parent-1].inBlender.makeParent([obj4ds.inBlender],0,1) # set parent for curr obj
            obj4ds.setBleTransf() 
            #obj4ds.setBleLayer() # too many time
            obj4ds.inBlender.addProperty('File',FILENAME,'STRING') 
            obj4ds.inBlender.addProperty('Sub Name',obj4ds.subname,'STRING')
            obj4ds.inBlender.addProperty('Type',obj4ds.type,'STRING')  
        SCENE.update(1)
        Window.Redraw() 
        
        
#ff= 'D:\\citybar2\\CASINO+\\models\\CASINO.4DS' 
#ff= 'E:\\lh-tram\\models\\salina.4DS'
#ff= 'E:\\CocaColaTruck\\models\\fire00.4ds'
#ff= 'E:\\Citroen_Traction_11_b\\models\\CitrTract11b00.4ds'
#ff= 'e:\\xfiles\mafia_mod_coll\\1mafia_mod_coll\\cars\\BMW_330i_E90_Police\\BMW_330i_E90_police.4ds'
        
def importFromFile(f):
    global POSITION, FILENAME
    POSITION= Matrix([1,0,0,0],
                     [0,1,0,0],
                     [0,0,1,0],
                     Window.GetCursorPos()+[1])
    Window.WaitCursor(1)
    tt0 =  bsys.time()  
    Window.EditMode(0)
    SCENE_OBJECTS.selected= []  
    print '\n'*3
    gc.disable()
    FILENAME= bsys.basename(f)
    file4= file4ds()
    t0= bsys.time()
    file4.load(f)
    t1= bsys.time()
    print 'time load: ', t1-t0
    file4.toBlender() 
    t2= bsys.time()    
    print 'time toBlender: ',t2-t1
    print 'VERTEX_COUNT: ', VERTEX_COUNT                       
    print 'FACE_COUNT: ', FACE_COUNT      
    gc.enable()
    gc.collect() 
    t3= bsys.time()
    print 'GS work time: ', t3-t2
    tt1 =  bsys.time()
    print 'total time: ', tt1-tt0                   
    Window.WaitCursor(0) 

#importFromFile(ff)
Blender.Window.FileSelector(importFromFile, 'Import 4DS', 'd:\\mafia\\models\\black00.4ds')    

     


